<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Institute extends Model 
{

    protected $table = 'institutes';
    public $timestamps = true;

    public function religious_grouping()
    {
        return $this->belongsTo('ReligiousGrouping', 'religious_grouping_id');
    }

    public function assignment()
    {
        return $this->morphToMany('App\Models\Assignment', 'assignment_type');
    }

    public function location()
    {
        return $this->belongsTo('Location', 'location_id');
    }

}